/*
 * Decompiled with CFR 0.152.
 */
package jade.imtp.leap;

import jade.core.IMTPException;
import jade.imtp.leap.Command;
import jade.imtp.leap.CommandDispatcher;
import jade.imtp.leap.StubHelper;
import jade.mtp.TransportAddress;
import jade.util.Logger;
import jade.util.leap.ArrayList;
import jade.util.leap.List;
import jade.util.leap.Serializable;
import java.io.IOException;
import java.io.ObjectInputStream;

class Stub
implements Serializable {
    protected static final String UNRCH_ERROR_MSG = "Remote object unreachable";
    protected static final String DISP_ERROR_MSG = "Dispatcher error";
    protected List remoteTAs = new ArrayList();
    protected int remoteID;
    protected transient StubHelper theDispatcher = null;
    protected transient Logger myLogger = Logger.getMyLogger(this.getClass().getName());

    protected Stub() {
        this.theDispatcher = CommandDispatcher.getDispatcher();
    }

    protected Stub(int id) {
        this();
        this.remoteID = id;
    }

    protected void bind(StubHelper sh) {
        this.theDispatcher = sh;
    }

    protected void addTA(TransportAddress ta) {
        this.remoteTAs.add(ta);
    }

    protected void removeTA(TransportAddress ta) {
        this.remoteTAs.remove(ta);
    }

    protected void clearTAs() {
        this.remoteTAs.clear();
    }

    protected int checkResult(Command result, String[] expectedExceptions) throws IMTPException {
        if (result.getCode() == 2) {
            String exceptionName = (String)result.getParamAt(0);
            if (expectedExceptions != null) {
                int i = 0;
                while (i < expectedExceptions.length) {
                    if (exceptionName.equals(expectedExceptions[i])) {
                        return i + 1;
                    }
                    ++i;
                }
            }
            this.myLogger.log(Logger.WARNING, "EXCEPTION in remote container: " + exceptionName);
            throw new IMTPException(exceptionName + " occurred in remote container [" + (String)result.getParamAt(1) + "]");
        }
        if (result.getCode() != 1) {
            throw new IMTPException("Unknown code in result command");
        }
        return 0;
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.theDispatcher = CommandDispatcher.getDispatcher();
        this.myLogger = Logger.getMyLogger(this.getClass().getName());
    }
}

